class Sorter {
    private int[] Field;

    public Sorter(int[] AField) {
        Field = new int[AField.length];
        for (int i = 0; i < AField.length; i++)
            Field[i] = AField[i];
    }

    public Sorter(int FieldSize) {
        Field = new int[FieldSize];
    }

    public int getField(int Index) {
        return Field[Index];
    }

    public void setField(int Index, int Value) {
        Field[Index] = Value;
    }

    public void Sort() {
        int k, tmp;

        for (int i = 1; i < Field.length; i++) {
            k = 0;
            while ((k < i) & (Field[i] >= Field[k])) k++;
            if (k < i) {
                tmp = Field[i];
                for (int j = i; j > k; j--)
                    Field[j] = Field[j - 1];
                Field[k] = tmp;
            }
        }
    }

    public void randomFill() {
        for (int i = 0; i < Field.length; i++)
            Field[i] = (int)(java.lang.Math.random() * 100);
    }

    public String toString() {
        String s = "Field = (";

        for (int i = 0; i < Field.length; i++)
            s += Field[i] + (i != Field.length - 1 ? " | " : ")");

        return s;
    }
}

public class InsertSort {
    public static void main(String[] args) {
        System.out.print("Initializing...");
//        Sorter mySorter = new Sorter(10);
        Sorter mySorter = new Sorter(new int[] {
            11, 58, 59, 52, 44, 67, 26, 40
        });

        System.out.print(" - done\nFilling with random data...");
//        mySorter.randomFill();

        System.out.println(" - done\n\nOutput:");
        System.out.println(mySorter + "\n");

        System.out.print("Sorting...");
        mySorter.Sort();
        System.out.println(" - done\n\nOutput:");
        System.out.println(mySorter + "\n");
    }
}
